/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.GuiSupport;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.PlotElement;
import org.das2.graph.DasCanvas;
import org.das2.graph.GraphUtil;
import org.das2.util.LoggerManager;
import org.das2.util.awt.PdfGraphicsOutput;
import org.jdesktop.layout.GroupLayout;

public final class FontAndColorsDialog
extends JDialog {
    ApplicationModel app;
    Color[] fores;
    Color[] backs;
    private static final int ICON_SIZE = 16;
    private JButton backgroundColorButton;
    private JLabel canEmbedFontTF;
    private JButton dismissButton;
    private JLabel fontLabel;
    private JButton foregroundColorButton;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton pickFontButton;

    public FontAndColorsDialog(Frame parent, boolean modal, ApplicationModel app) {
        super(parent, modal);
        this.setTitle("Font and Colors");
        this.initComponents();
        this.app = app;
        DasCanvas c = app.getCanvas();
        this.fores = new Color[]{Color.BLACK, Color.WHITE, Color.WHITE};
        this.backs = new Color[]{Color.WHITE, Color.BLACK, Color.BLUE.darker()};
        String[] names = new String[]{"black on white", "white on black", "white on blue", "custom"};
        Font f = app.getCanvas().getFont();
        this.fontLabel.setText(DomUtil.encodeFont(f));
        Runnable run = () -> {
            Font f1 = Font.decode(this.fontLabel.getText());
            this.canEmbedFont(f1);
        };
        new Thread(run, "canEmbedFont").start();
        int index = 3;
        for (int i = 0; i < this.fores.length; ++i) {
            if (!this.fores[i].equals(c.getForeground()) || !this.backs[i].equals(c.getBackground())) continue;
            index = i;
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(names));
        if (index != -1) {
            this.jComboBox1.setSelectedIndex(index);
        }
        this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)c.getForeground(), (int)16, (int)16));
        this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)c.getBackground(), (int)16, (int)16));
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.foregroundColorButton = new JButton();
        this.backgroundColorButton = new JButton();
        this.jLabel4 = new JLabel();
        this.pickFontButton = new JButton();
        this.dismissButton = new JButton();
        this.fontLabel = new JLabel();
        this.canEmbedFontTF = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Fore/Back Colors:");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Foreground:");
        this.jLabel3.setText("Background:");
        this.foregroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.foregroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.backgroundColorButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Font:");
        this.pickFontButton.setText("Pick");
        this.pickFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.pickFontButtonActionPerformed(evt);
            }
        });
        this.dismissButton.setText("OK");
        this.dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontAndColorsDialog.this.dismissButtonActionPerformed(evt);
            }
        });
        this.fontLabel.setText("jLabel5");
        this.canEmbedFontTF.setFont(this.canEmbedFontTF.getFont().deriveFont((float)this.canEmbedFontTF.getFont().getSize() - 1.0f));
        this.canEmbedFontTF.setText("   ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.canEmbedFontTF, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.foregroundColorButton, -2, 20, -2)).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.backgroundColorButton, -2, 18, -2)).add((Component)this.jComboBox1, -2, 173, -2)).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.fontLabel, -1, 232, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pickFontButton)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.dismissButton))).addContainerGap()));
        layout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBox1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.backgroundColorButton).add((Component)this.foregroundColorButton, -2, 17, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.pickFontButton).add((Component)this.fontLabel)).addPreferredGap(0).add((Component)this.canEmbedFontTF, -2, 20, -2).addPreferredGap(0, 103, Short.MAX_VALUE).add((Component)this.dismissButton).addContainerGap()));
        layout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 2);
        this.pack();
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.dispose();
    }

    private void pickFontButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        Font f = GuiSupport.pickFont((JFrame)SwingUtilities.getWindowAncestor(this), this.app);
        if (f != null) {
            this.fontLabel.setText(DomUtil.encodeFont(f));
            this.canEmbedFont(f);
        }
    }

    private void backgroundColorButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        Color c = JColorChooser.showDialog(this, "background color", this.backgroundColorButton.getBackground());
        if (c != null) {
            this.jComboBox1.setSelectedIndex(this.fores.length);
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
            this.app.getCanvas().setBackground(c);
            this.app.getDom().getOptions().setBackground(c);
        }
    }

    private void foregroundColorButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        Color c = JColorChooser.showDialog(this, "foreground color", this.foregroundColorButton.getBackground());
        if (c != null) {
            this.jComboBox1.setSelectedIndex(this.fores.length);
            List<PlotElement> pe = Arrays.asList(this.app.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.app.getCanvas().getForeground())) continue;
                p.getStyle().setColor(c);
            }
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)c, (int)16, (int)16));
            this.app.getCanvas().setForeground(c);
            this.app.getDom().getOptions().setForeground(c);
            this.app.getDom().getOptions().setColor(c);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        int i = this.jComboBox1.getSelectedIndex();
        if (i < this.fores.length) {
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon((Color)this.fores[i], (int)16, (int)16));
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon((Color)this.backs[i], (int)16, (int)16));
            List<PlotElement> pe = Arrays.asList(this.app.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.app.getCanvas().getForeground())) continue;
                p.getStyle().setColor(this.fores[i]);
            }
            this.app.getDom().getOptions().setForeground(this.fores[i]);
            this.app.getDom().getOptions().setColor(this.fores[i]);
            this.app.getDom().getOptions().setBackground(this.backs[i]);
        }
    }

    private void canEmbedFont(Font f) {
        String s = PdfGraphicsOutput.ttfFromName((Font)f);
        if (s != null) {
            this.canEmbedFontTF.setText("PDF okay");
            this.canEmbedFontTF.setToolTipText("font should work in PDF files");
        } else {
            this.canEmbedFontTF.setText("font can not be embedded in PDF");
            this.canEmbedFontTF.setToolTipText("TTF file not found or licensing restricts use");
        }
    }
}

